<?php
// deploy_revive.php
// Script untuk "menghidupkan kembali" URL lama dengan konten tunneling
// Tidak mengganggu file index.php utama (Homepage)

// Konfigurasi
$slugsFile = 'slugs.txt';
$keywordsFile = 'default.txt';
$templateFile = 'template.php';
$baseURL = "https://spooksandspirits.com"; // Ganti sesuai domain Anda

// 1. Cek Kelengkapan File
if (!file_exists($slugsFile) || !file_exists($keywordsFile) || !file_exists($templateFile)) {
    die("❌ Error: Salah satu file wajib tidak ditemukan (slugs.txt, default.txt, template.php).");
}

// 2. Baca Data
$slugs = file($slugsFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$keywords = file($keywordsFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$templateContent = file_get_contents($templateFile);

if (empty($slugs)) {
    die("❌ Error: File slugs.txt kosong.");
}
if (empty($keywords)) {
    die("❌ Error: File default.txt kosong.");
}

$totalKeywords = count($keywords);
$keywordIndex = 0;
$sitemapUrls = [rtrim($baseURL, '/') . '/']; // Penampung URL untuk sitemap.xml root (Main Domain duluan)

echo "🚀 Memulai proses deploy revive...\n";
echo "Jumlah Slugs: " . count($slugs) . "\n";
echo "Jumlah Keywords: " . $totalKeywords . "\n\n";

// --- DATA SUMBER UNTUK SPINTAX KOMENTAR ---
// Anda bisa mengubah isi kalimat di bawah ini sesuai selera.
// Format Spintax: {Opsi A|Opsi B|Opsi C}
$commentTemplates = [
    // Template untuk {komentar1}
    "[BRAND] {is proven to be profitable|gives easy jackpots|offers huge winning chances|has active high RTP|frequently hits maxwin}, {withdrawals are instant|CS is responsive 24/7|process is super fast|transactions are safe & trusted|service is satisfying} from the start.",
    
    // Template untuk {komentar2}
    "Just tried [BRAND] and {immediately hit jackpot|won easily|got abundant bonuses|scatters appear often|live RTP is accurate}, {instant withdrawal|friendly customer service|fair play system|hassle-free|easy process}.",
    
    // Template untuk {komentar3}
    "Playing at [BRAND] {keeps giving jackpots|offers abundant maxwins|has high winrate|anti-loss guarantee|brings huge profits}, {24/7 service ready to help|fastest withdrawal|secure platform|big bonuses|highest RTP}.",

    // Template untuk {komentar4}
    "[BRAND] {offers real jackpot chances|breaks easily every day|gives big new member bonuses|has transparent live RTP|maxwin is easy to reach}, {professional CS|instant withdrawal|trusted transactions|fast support|advanced system}."
];

foreach ($slugs as $slug) {
    // Bersihkan slug dari slash awal/akhir agar rapi untuk pembutan folder
    $cleanSlug = trim($slug, "/\\");
    
    // Cek apakah slug asli memiliki trailing slash
    $hasTrailingSlash = (substr(trim($slug), -1) === '/');
    
    // Skip jika slug kosong
    if (empty($cleanSlug)) { 
        continue; 
    }

    // Tentukan path direktori fisik
    $dirPath = __DIR__ . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $cleanSlug);
    
    // a. Buat Direktori (Recursive)
    if (!is_dir($dirPath)) {
        if (!mkdir($dirPath, 0777, true)) {
            echo "⚠️  Gagal membuat folder: $cleanSlug\n";
            continue;
        }
    }

    // b. Ambil Keyword (Rotasi - jika habis, ulang dari awal)
    $currentKeyword = $keywords[$keywordIndex % $totalKeywords];
    $keywordIndex++;

    // c. Siapkan Konten Template
    $pageContent = $templateContent;

    // LOGIKA CERDAS:
    // Cek apakah keyword ini "fresh" atau "hasil rotasi" (daur ulang karena stok habis)
    $isRotation = ($keywordIndex > $totalKeywords); // Index sudah melewati jumlah total
    
    // --- LOGIKA BARU: SPINTAX & COMMENT ---
    // Placeholder [BRAND] diganti dengan Keyword saat ini
    $cKwdUpper = strtoupper($currentKeyword);
    $tpl1 = str_replace('[BRAND]', $cKwdUpper, $commentTemplates[0]);
    $tpl2 = str_replace('[BRAND]', $cKwdUpper, $commentTemplates[1]);
    $tpl3 = str_replace('[BRAND]', $cKwdUpper, $commentTemplates[2]);
    $tpl4 = str_replace('[BRAND]', $cKwdUpper, $commentTemplates[3]);

    // Generate Komentar Unik
    $komentar1 = spinText($tpl1);
    $komentar2 = spinText($tpl2);
    $komentar3 = spinText($tpl3);
    $komentar4 = spinText($tpl4);
    
    if ($isRotation) {
         // JIKA ROTASI (Keyword Daur Ulang) -> Tambahkan Slug di belakang agar Unik
        $slugDesc = ucwords(str_replace(['-', '/'], ' ', basename($cleanSlug)));
        
        // Format Panjang + Slug di akhir + SPINTAX
        $rawTitle = strtoupper($currentKeyword) . " {:|#|-} {Official Game Online Site|Trusted Gaming Platform|Premium Online Game Link|Best Gaming Website|Top Rated Online Game} featuring {High Winning Potential Slots|Massive Daily Jackpots|High RTP & Maxwin Games|Easy Wins & Big Rewards|The Best Online Gaming Experience} {& 24/7 Support|Fast Withdrawals|Secure Transactions|Instant Access|Responsive CS} - " . $slugDesc;
        $rawDesc  = strtoupper($currentKeyword) . " {presents|offers|provides|delivers} {the ultimate online gaming experience|an exclusive gaming journey|premium access to online games|top-tier gaming services} with {real jackpot opportunities|high RTP and daily wins|proven high winrates|massive rewards and bonuses}, {backed by 24/7 customer support|ensuring fast and secure transactions|supported by professional CS|guaranteeing instant withdrawals} {for every player|for all gaming enthusiasts|accessible to everyone|safe for all members}. - " . $slugDesc;
        
    } else {
        // JIKA FRESH (Stok Keyword Masih Ada) -> Format Murni + SPINTAX
        $rawTitle = strtoupper($currentKeyword) . " {:|#|-} {Official Game Online Site|Trusted Gaming Platform|Premium Online Game Link|Best Gaming Website|Top Rated Online Game} featuring {High Winning Potential Slots|Massive Daily Jackpots|High RTP & Maxwin Games|Easy Wins & Big Rewards|The Best Online Gaming Experience} {& 24/7 Support|Fast Withdrawals|Secure Transactions|Instant Access|Responsive CS}";
        $rawDesc  = strtoupper($currentKeyword) . " {presents|offers|provides|delivers} {the ultimate online gaming experience|an exclusive gaming journey|premium access to online games|top-tier gaming services} with {real jackpot opportunities|high RTP and daily wins|proven high winrates|massive rewards and bonuses}, {backed by 24/7 customer support|ensuring fast and secure transactions|supported by professional CS|guaranteeing instant withdrawals} {for every player|for all gaming enthusiasts|accessible to everyone|safe for all members}.";
    }
    
    // Apply Spintax ke Title & Desc
    $finalTitle = spinText($rawTitle);
    $finalDesc = spinText($rawDesc);
    
    // Replacement Logic
    $pageContent = str_replace('{TITLE}', $finalTitle, $pageContent);
    $pageContent = str_replace('{DESCRIPTION}', $finalDesc, $pageContent);
    
    // Inject Komentar
    $pageContent = str_replace('{komentar1}', $komentar1, $pageContent);
    $pageContent = str_replace('{komentar2}', $komentar2, $pageContent);
    $pageContent = str_replace('{komentar3}', $komentar3, $pageContent);
    $pageContent = str_replace('{komentar4}', $komentar4, $pageContent);

    // Jika template Anda pakai {KEYWORD}, aktifkan baris ini:
    // $pageContent = str_replace('{KEYWORD}', $currentKeyword, $pageContent); 
    
    // d. Logika URL AMP & Image
    // Di template asli, $amp = '{AMP}' . strtoupper($aduh_cleaned);
    // Jadi kita harus isi {AMP} dengan Base URL AMP Provider Anda.
    
    // Sesuaikan Base URL AMP Anda di sini (Lihat config.json lama Anda)
    // Contoh: https://spooks.ampguardx.com/
    $ampBaseURL = "https://spooks.ampguardx.com/"; 
    
    // Kita replace {AMP} dengan Base URL saja, karena di template.php baris 14 
    // dia akan menggabungkannya sendiri dengan keyword: 
    // $amp = '{AMP}' . strtoupper($aduh_cleaned);
    
    $pageContent = str_replace('{AMP}', $ampBaseURL, $pageContent);
    
    // IMAGE PLACEHOLDER
    // Ganti URL ini dengan URL gambar banner eksternal Anda. (Bisa CDN, Google Drive, atau hosting lain)
    $globalImageURL = "https://images.cdn-fastspeed.dev/banner-TL001.webp"; 
    $pageContent = str_replace('{IMAGE}', $globalImageURL, $pageContent);
    
    // CRITICAL FIX: Inject Keyword ke Variabel PHP $aduh
    // Agar konten body (Menu, Teks) berubah sesuai keyword, bukan default "SLOT-GACOR"
    // Kita cari baris: $aduh = "SLOT-GACOR"; dan ubah nilainya.
    $pageContent = str_replace('$aduh = "SLOT-GACOR";', '$aduh = "' . $currentKeyword . '";', $pageContent);
    
    // --- LOGIKA HARDCODED CANONICAL BERDASARKAN SLUGS.TXT ---
    // 1. Tentukan URL Canonical Target
    $cleanBaseURL = rtrim($baseURL, '/');
    if ($hasTrailingSlash) {
        $targetCanonical = "$cleanBaseURL/$cleanSlug/";
    } else {
        $targetCanonical = "$cleanBaseURL/$cleanSlug";
    }
    
    // 2. Inject URL ini ke variable $nical di dalam script PHP Template
    // Menggunakan regex atau str_replace dengan marker yang lebih unik agar tidak gampang error
    $canonicalPattern = '/\/\/ \[CANONICAL_START\].*?\/\/ \[CANONICAL_END\]/s';
    $canonicalReplacement = '$nical = "' . $targetCanonical . '";';
    
    $pageContent = preg_replace($canonicalPattern, $canonicalReplacement, $pageContent);
    
    
    // d. Tulis file index.php
    $targetFile = $dirPath . '/index.php';
    
    // Safety check: Jangan overwrite homepage (root index.php) meski ada di list slug
    if (realpath($dirPath) == __DIR__) {
        echo "⚠️  Skip: Mencoba menimpa Root Directory (Bahaya).\n";
        continue;
    }

    if (file_put_contents($targetFile, $pageContent)) {
        echo "✅ Created: /$cleanSlug -> Keyword: $currentKeyword";
        if ($hasTrailingSlash) echo " (Trailing Slash)";
        echo "\n";
        
        // FAILSAFE: Copy data.txt
        // Template butuh 'data.txt' untuk validasi (baris 18 template.php)
        copy($keywordsFile, $dirPath . '/data.txt');
        
        // Catat success untuk sitemap root
        // Gunakan $targetCanonical agar konsisten di sitemap
        $sitemapUrls[] = $targetCanonical;

    } else {
        echo "❌ Gagal menulis file: $cleanSlug\n";
    }
}

// 4. Generate ROOT Sitemap.xml
echo "\n🗺️  Membuat sitemap.xml di root...\n";
$sitemapXml = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
$sitemapXml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";

foreach ($sitemapUrls as $url) {
    // Tentukan Priority: Homepage 1.0, Sisanya 0.8
    $priority = ($url === rtrim($baseURL, '/') . '/') ? '1.0' : '0.8';

    $sitemapXml .= "  <url>\n";
    $sitemapXml .= "    <loc>" . htmlspecialchars($url) . "</loc>\n";
    $sitemapXml .= "    <lastmod>" . date('Y-m-d') . "</lastmod>\n";
    $sitemapXml .= "    <changefreq>daily</changefreq>\n";
    $sitemapXml .= "    <priority>$priority</priority>\n";
    $sitemapXml .= "  </url>\n";
}

$sitemapXml .= '</urlset>';

if (file_put_contents('sitemap.xml', $sitemapXml)) {
    echo "✅ sitemap.xml berhasil dibuat! (" . count($sitemapUrls) . " URL)\n";
} else {
    echo "❌ Gagal membuat sitemap.xml\n";
}

// 5. Generate ROOT robots.txt
echo "\n🤖 Membuat robots.txt di root...\n";
$robotsTxt = "User-agent: *\n";
$robotsTxt .= "Allow: /\n";
$robotsTxt .= "Sitemap: " . rtrim($baseURL, '/') . "/sitemap.xml\n";

if (file_put_contents('robots.txt', $robotsTxt)) {
    echo "✅ robots.txt berhasil dibuat!\n";
} else {
    echo "❌ Gagal membuat robots.txt\n";
}

echo "\n🎉 Selesai! Semua halaman telah dibangkitkan.";

// --- HELPER FUNCTION: SPINTAX ---
function spinText($text) {
    return preg_replace_callback(
        '/\{([^{}]+)\}/',
        function($matches) {
            $options = explode('|', $matches[1]);
            return $options[array_rand($options)]; // Pilih acak
        },
        $text
    );
}
?>
